<?php

namespace Modules\Qbo\Repositories;

use App\Abstractions\Integrations\AbstractIntegrationRepository;
use App\Abstractions\Integrations\Accounting\AccountingTaxCodeRepositoryInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use Carbon\Carbon;
use Modules\Qbo\Entities\QboTaxCode;

class QboTaxCodeRepository extends AbstractIntegrationRepository implements AccountingTaxCodeRepositoryInterface
{
    public function getModelClassName(): string
    {
        return QboTaxCode::class;
    }

    public function getStartDateField(): string
    {
        return 'LastUpdatedTimeUtc';
    }

    public function getStartDateForNew(IntegrationInstanceInterface $integrationInstance): Carbon
    {
        return Carbon::now();
    }
}
