<?php

namespace Modules\Qbo\Repositories;

use App\Abstractions\Integrations\Accounting\AbstractAccountingPaymentRepository;
use Modules\Qbo\Entities\QboPayment;

class QboPaymentRepository extends AbstractAccountingPaymentRepository
{
    public function getModelClassName(): string
    {
        return QboPayment::class;
    }

    public function deletePayments(array $qboIds): void
    {
        QboPayment::whereIn('QboId', $qboIds)->delete();
    }
}
