<?php

namespace Modules\Qbo\Repositories;

use App\Abstractions\Integrations\AbstractIntegrationInstanceRepository;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Models\Integration;
use Modules\Qbo\Entities\QboIntegrationInstance;

class QboIntegrationInstanceRepository extends AbstractIntegrationInstanceRepository
{
    public function getIntegrationName(): string
    {
        return Integration::NAME_QBO;
    }

    public function getIntegrationInstanceClassName(): string
    {
        return QboIntegrationInstance::class;
    }

    public function getIntegration(): Integration
    {
        return Integration::where('name', Integration::NAME_QBO)->firstOrFail();
    }

    public function initialize(): QboIntegrationInstance|IntegrationInstanceInterface
    {
        return QboIntegrationInstance::query()->firstOrCreate([
            'name' => 'Quickbooks Online',
            'integration_id' => Integration::where('name', Integration::NAME_QBO)->firstOrFail()->id,
        ], [
            'connection_settings' => [],
            'integration_settings' => [],
        ]);
    }
}
