<?php

namespace Modules\Qbo\Repositories;

use App\Abstractions\Integrations\AbstractIntegrationRepository;
use App\Abstractions\Integrations\Accounting\AccountingCustomerRepositoryInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use Carbon\Carbon;
use Modules\Qbo\Entities\QboCustomer;

class QboCustomerRepository extends AbstractIntegrationRepository implements AccountingCustomerRepositoryInterface
{
    public function getModelClassName(): string
    {
        return QboCustomer::class;
    }

    public function getStartDateField(): string
    {
        return 'LastUpdatedTimeUtc';
    }

    public function getStartDateForNew(IntegrationInstanceInterface $integrationInstance): Carbon
    {
        return Carbon::now();
    }

    public function getQboCustomerByDisplayName(string $displayName): ?QboCustomer
    {
        return QboCustomer::where('DisplayName', $displayName)->first();
    }
}
