<?php

namespace Modules\Qbo\Providers;

use Illuminate\Queue\Events\JobProcessed;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Queue;
use Illuminate\Support\ServiceProvider;
use Modules\Qbo\Jobs\QboUpdateOrCreateBillsJob;
use Modules\Qbo\Jobs\QboUpdateOrCreateCreditMemosJob;
use Modules\Qbo\Jobs\QboUpdateOrCreateInvoicesJob;
use Modules\Qbo\Jobs\QboUpdateOrCreateJournalsJob;
use Modules\Qbo\Jobs\QboUpdateOrCreatePaymentsJob;
use Modules\Qbo\Jobs\QboUpdateOrCreatePurchaseOrdersJob;

class QboJobProvider extends ServiceProvider
{
    private JobProcessed $jobEvent;

    private function isRepeatableJob()
    {
        foreach ([
            QboUpdateOrCreateInvoicesJob::class,
        ] as $jobName) {
            if ($this->jobEvent->job->resolveName() === $jobName) {
                return true;
            }
        }
    }

    private function repeatJob()
    {
        switch ($this->jobEvent->job->resolveName()) {
            case QboUpdateOrCreateInvoicesJob::class:
                Artisan::call('qbo:sync:invoices');
                break;

            case QboUpdateOrCreatePurchaseOrdersJob::class:
                Artisan::call('qbo:sync:purchase-orders');
                break;

            case QboUpdateOrCreateBillsJob::class:
                Artisan::call('qbo:sync:bills');
                break;

            case QboUpdateOrCreateJournalsJob::class:
                Artisan::call('qbo:sync:journals');
                break;

            case QboUpdateOrCreatePaymentsJob::class:
                Artisan::call('qbo:sync:invoice-payments');
                break;

            case QboUpdateOrCreateCreditMemosJob::class:
                Artisan::call('qbo:sync:credit-memos');
                break;
        }
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {

        Queue::after(function (JobProcessed $event) {
            $this->jobEvent = $event;

            if ($this->isRepeatableJob($event)) {
                $this->repeatJob($event);
            }
        });
    }

    /**
     * Get the services provided by the provider.
     */
    public function provides(): array
    {
        return [];
    }
}
