<?php

namespace Modules\Qbo\Jobs;

use Exception;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\Data\QboResponseData;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Manager\QboManager;

class RefreshQboTaxRatesJob extends QboJob
{
    public function __construct(
        protected QboIntegrationInstance $integrationInstance,
        protected QboQueryApo $parameters,
    ) {
        $this->onQueue('accounting');

        $this->limit = $parameters->maxResults;
    }

    /**
     * Execute the job.
     *
     * @return void
     *
     * @throws Exception
     */
    public function apiCall(): QboResponseData
    {
        if (@$this->jobPayload['startPosition']) {
            $this->parameters->startPosition = $this->jobPayload['startPosition'];
        }

        return (new QboManager($this->integrationInstance))->refreshTaxRates($this->parameters);
    }
}
