<?php

namespace Modules\Qbo\Jobs;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Models\AccountingTransaction;
use Modules\Qbo\Entities\QboCustomer;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Manager\QboManager;

abstract class QboUpdateOrCreateSaleJob extends QboJob
{
    protected QboManager $qboManager;

    public function __construct(
        protected QboIntegrationInstance $integrationInstance,
        protected ApiDataTransformerInterface $parameters
    ) {
        $this->onQueue('accounting');

        $this->qboManager = new QboManager($this->integrationInstance);

        parent::__construct();
    }

    public function syncCustomers()
    {
        $customerDisplayNames = $this->parameters->accountingTransactions->map(function (AccountingTransaction $accountingTransaction) {
            return $accountingTransaction->link?->customer?->name ?? QboCustomer::MISSING_CUSTOMER_NAME;
        });

        //Make sure supplier exists
        $this->qboManager->syncCustomers($customerDisplayNames->toArray());
    }
}
