<?php

namespace Modules\Qbo\Jobs;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Exception;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreateJournalsApo;
use Modules\Qbo\Data\QboResponseData;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Manager\QboManager;

class QboUpdateOrCreateJournalsJob extends QboJob implements ShouldBeEncrypted, ShouldBeUnique
{
    public function __construct(
        private QboIntegrationInstance $integrationInstance,
        private QboUpdateOrCreateJournalsApo|ApiDataTransformerInterface $parameters
    ) {
    }

    /**
     * Execute the job.
     *
     * @return void
     *
     * @throws Exception
     */
    public function apiCall(): QboResponseData
    {
        return (new QboManager($this->integrationInstance))->syncJournals($this->parameters);
    }
}
