<?php

namespace Modules\Qbo\Jobs;

use App\Models\AccountingTransaction;
use App\Models\AccountingTransactionLine;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreateBillsApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreatePurchaseOrdersApo;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Entities\QboItem;
use Modules\Qbo\Manager\QboManager;

abstract class QboUpdateOrCreateExpenseJob extends QboJob
{
    protected QboManager $qboManager;

    public function __construct(
        protected QboIntegrationInstance $integrationInstance,
        protected QboUpdateOrCreatePurchaseOrdersApo|QboUpdateOrCreateBillsApo $parameters
    ) {
        $this->onQueue('accounting');

        $this->qboManager = new QboManager($this->integrationInstance);
    }

    public function syncVendors()
    {
        $supplierDisplayNames = $this->parameters->accountingTransactions->map(function (AccountingTransaction $accountingTransaction) {
            return $accountingTransaction->link?->supplier?->name;
        });

        //Make sure supplier exists
        $this->qboManager->syncVendors($supplierDisplayNames->toArray());
    }

    public function syncProducts()
    {
        $productNames = collect();

        $this->parameters->accountingTransactions->each(function (AccountingTransaction $accountingTransaction) use (&$productNames) {
            $accountingTransaction->accountingTransactionLines->each(function (AccountingTransactionLine $accountingTransactionLine) use (&$productNames) {
                $hasMissingSku = true;

                if ($accountingTransactionLine->link?->product?->sku) {
                    $productNames->push($accountingTransactionLine->link?->product?->sku);
                } elseif (! $hasMissingSku) {
                    $productNames->push(QboItem::MISSING_SKU);
                }
            });
        });

        
        //Create taxable item
        if ($this->integrationInstance->isTaxPayableSeparated()) {
            $productNames->push(QboItem::TAX_PAYABLE_ITEM);
        }

        //Make sure product exists
        $this->qboManager->syncProducts($productNames->toArray());
    }
}
