<?php

namespace Modules\Qbo\Jobs;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Models\Payment;
use App\Models\SalesCreditLine;
use Exception;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreateCreditMemosApo;
use Modules\Qbo\Data\QboResponseData;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Manager\QboManager;

class QboUpdateOrCreateCreditMemosPaymentJob extends QboUpdateOrCreateSaleJob implements ShouldBeEncrypted, ShouldBeUnique
{
    public function __construct(
        QboIntegrationInstance $integrationInstance,
        QboUpdateOrCreateCreditMemosApo|ApiDataTransformerInterface $parameters
    ) {
        parent::__construct($integrationInstance, $parameters);
    }

    public function syncProducts()
    {
        $productNames = collect();

        $this->parameters->payments->each(function (Payment $payment) use (&$productNames) {
            $payment->link->salesCreditLines->each(function (SalesCreditLine $salesCreditLine) use (&$productNames) {
                if ($salesCreditLine->product?->sku) {
                    $productNames->push($salesCreditLine->product?->sku);
                }

            });
        });

        //Make sure product exists
        $this->qboManager->syncProducts($productNames->toArray());
    }

    /**
     * Execute the job.
     *
     * @return void
     *
     * @throws Exception
     */
    public function apiCall(): QboResponseData
    {
        $this->syncProducts();

        return (new QboManager($this->integrationInstance))->syncSalesCredits($this->parameters);
    }
}
