<?php

namespace Modules\Qbo\Http\Controllers;

use App\Abstractions\Integrations\Accounting\AbstractAccountingVendorController;
use App\Response;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Manager\QboManager;

class QboVendorController extends AbstractAccountingVendorController
{
    /**
     * @throws Throwable
     */
    public function sync(QboIntegrationInstance $integrationInstance): Response
    {
        (new QboManager($integrationInstance))->syncVendors();

        return $this->response->setMessage('Added to queue, accounts will be refreshed shortly.');
    }
}
