<?php

namespace Modules\Qbo\Http\Controllers;

use App\Abstractions\Integrations\Accounting\AbstractAccountingTaxRateController;
use App\Response;
use Illuminate\Http\Request;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Entities\QboTaxCode;
use Modules\Qbo\Http\Resources\QboTaxCodeResource;
use Modules\Qbo\Jobs\RefreshQboTaxCodesJob;

class QboTaxCodeController extends AbstractAccountingTaxRateController
{
    public function getModel(): string
    {
        return QboTaxCode::class;
    }

    public function getResource(): string
    {
        return QboTaxCodeResource::class;
    }

    /**
     * @throws Throwable
     */
    public function refresh(QboIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractRefresh(new RefreshQboTaxCodesJob($integrationInstance, new QboQueryApo()));
    }

    public function indexForIntegration(Request $request, QboIntegrationInstance $integrationInstance)
    {
        return parent::abstractIndexForIntegration($request, $integrationInstance);
    }
}
