<?php

namespace Modules\Qbo\Entities;

use App\Models\Concerns\HasFilters;
use App\Models\Contracts\Filterable;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Kirschbaum\PowerJoins\PowerJoins;
use Modules\Qbo\Database\factories\QboTaxCodeFactory;

class QboTaxCode extends QboModel implements Filterable
{
    use HasFactory;
    use HasFilters;
    use PowerJoins;

    const BULK_THRESHOLD = 1;

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */
    public static function newFactory(): Factory
    {
        return QboTaxCodeFactory::new();
    }
}
