<?php

namespace Modules\Qbo\Entities;

use App\Models\Concerns\BulkImport;
use App\Models\Concerns\HasFilters;
use Carbon\Carbon;
use Kirschbaum\PowerJoins\PowerJoins;

/**
 * @property int $id
 * @property string $QboId
 * @property string $PaymentRefNum
 * @property array $json_object
 * @property Carbon $updated_at
 * @property Carbon $created_at
 */
class QboPayment extends QboModel
{
    use BulkImport;
    use HasFilters;
    use PowerJoins;

    const BULK_THRESHOLD = 1;

    protected $guarded = [];

    protected $casts = [
        'QboId' => 'string',
        'PaymentRefNum' => 'string',
        'json_object' => 'array',
    ];

    public static function getDocNumberUniqueField(): string
    {
        return 'PaymentRefNum';
    }

    public function getLink(): ?string
    {
        return config('qbo.entityLink').'/recvpayment?txnId='.$this->QboId;
    }
}
