<?php

namespace Modules\Qbo\Entities;

use App\Abstractions\Integrations\Accounting\AbstractAccountingModel;
use App\Abstractions\Integrations\IntegrationModelInterface;
use App\DataTable\DataTableModelInterface;
use App\DataTable\DataTableModelTrait;
use App\Services\Accounting\AccountingIntegration;
use Awobaz\Compoships\Database\Eloquent\Relations\BelongsTo;
use Carbon\Carbon;

abstract class QboModel extends AbstractAccountingModel implements AccountingIntegration, DataTableModelInterface, IntegrationModelInterface
{
    use DataTableModelTrait;

    public function getLastSyncedAt(): ?Carbon
    {
        if (@$this->json_object['LastUpdatedTimeUtc']) {
            return Carbon::parse($this->json_object['LastUpdatedTimeUtc']);
        }

        return null;
    }

    public function getLastError(): ?array
    {
        return null;
    }

    public function getLink(): ?string
    {
        return null;
    }

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function qboIntegrationInstance(): BelongsTo
    {
        return $this->integrationInstance();
    }

    /*
    |--------------------------------------------------------------------------
    | Other
    |--------------------------------------------------------------------------
    */

    public function filterableColumns(): array
    {
        return array_keys($this->availableColumns());
    }

    public static function getDocNumberUniqueField(): ?string
    {
        return null;
    }

    public static function getUniqueField(): string
    {
        return 'QboId';
    }
}
