<?php

namespace Modules\Qbo\Entities;

use App\Models\Concerns\BulkImport;
use App\Models\Concerns\HasFilters;
use Carbon\Carbon;
use Kirschbaum\PowerJoins\PowerJoins;

/**
 * @property int $id
 * @property string $QboId
 * @property string $Name
 * @property array $json_object
 * @property Carbon $updated_at
 * @property Carbon $created_at
 */
class QboJournal extends QboModel
{
    use BulkImport;
    use HasFilters;
    use PowerJoins;

    const BULK_THRESHOLD = 1;

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    public static function getDocNumberUniqueField(): string
    {
        return 'DocNumber';
    }

    public function getLink(): ?string
    {
        return config('qbo.entityLink').'/journal?txnId='.$this->QboId;
    }
}
