<?php

namespace Modules\Qbo\Entities;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Models\ApiLog;
use App\Models\Integration;
use App\Models\IntegrationInstance;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\DB;
use Modules\Qbo\Database\factories\QboIntegrationInstanceFactory;
use Throwable;

class QboIntegrationInstance extends IntegrationInstance implements IntegrationInstanceInterface
{
    protected $table = 'integration_instances';

    protected $primaryKey = 'id';

    protected static function booted(): void
    {
        static::addGlobalScope('qbo', function (Builder $query) {
            return $query->whereHas('integration', function (Builder $query) {
                $query->where('name', Integration::NAME_QBO);
            });
        });
    }

    /*
     |--------------------------------------------------------------------------
     | Relations
     |--------------------------------------------------------------------------
     */

    public function apiLogs(): HasMany
    {
        return $this->hasMany(ApiLog::class, 'integration_instance_id');
    }

    /*
    |--------------------------------------------------------------------------
    | Other
    |--------------------------------------------------------------------------
    */

    /**
     * @throws Throwable
     */
    public function delete(): void
    {
        set_time_limit(0);
        DB::transaction(function () {
            /*
             * Clear all related records
             *
             * Many other models get deleted but handled through corresponding models
             */
            parent::delete();
        });
    }

    public static function newFactory(): Factory
    {
        return QboIntegrationInstanceFactory::new();
    }

    public function isTaxPayableSeparated()
    {
        return true;
    }
}
