<?php

namespace Modules\Qbo\Entities;

use App\Models\Concerns\HasFilters;
use App\Models\Contracts\Filterable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Kirschbaum\PowerJoins\PowerJoins;
use Modules\Qbo\Database\factories\QboPurchaseOrderFactory;

/**
 * @property int $id
 * @property string $DocNumber
 * @property string $QboId
 * @property array $json_object
 * @property Carbon $updated_at
 * @property Carbon $created_at
 */
class QboBill extends QboModel implements Filterable
{
    use HasFactory;
    use HasFilters;
    use PowerJoins;

    const BULK_THRESHOLD = 1;

    protected $guarded = [];

    protected $casts = [
        'QboId' => 'string',
        'LastUpdatedTimeUtc' => 'datetime',
        'json_object' => 'array',
    ];

    public static function getDocNumberUniqueField(): string
    {
        return 'DocNumber';
    }

    public static function newFactory(): Factory
    {
        return QboPurchaseOrderFactory::new();
    }

    public function getLink(): ?string
    {
        return config('qbo.entityLink').'/bill?txnId='.$this->QboId;
    }
}
