<?php

namespace Modules\Qbo\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Qbo\Entities\QboTransaction;

class QboTransactionFactory extends Factory
{
    protected $model = QboTransaction::class;

    public function definition(): array
    {
        return [
            'uuid' => $this->faker->uuid(), //
            'type' => $this->faker->word(),
            'last_error' => $this->faker->words(),
            'json_object' => $this->faker->words(),
            'request_body' => $this->faker->words(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
