<?php

namespace Modules\Qbo\Database\factories;

use App\Models\Integration;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Qbo\Entities\QboIntegrationInstance;

class QboIntegrationInstanceFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = QboIntegrationInstance::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var Integration $integration */
        $integration = Integration::query()->firstOrCreate(
            ['name' => Integration::NAME_QBO],
            ['integration_type' => Integration::TYPE_ACCOUNTING]
        );

        return [
            'integration_id' => $integration->id,
            'name' => 'QBO',
            'connection_settings' => [
                'refresh_token' => 'AB11718454051mGIHfr8gN7W7Xdi63wGUCKMHnAHglY5lX80YG', //$this->faker->sentence(10),
                'realmId' => '4620816365311137060', //$this->faker->randomNumber(),
                'access_token' => 'eyJlbmMiOiJBMTI4Q0JDLUhTMjU2IiwiYWxnIjoiZGlyIn0..A814_YIENp92MTDi2VD4XA.zZ3uCWVRsUnElPij0z-paAJkxFUqGvjZlVC1P_ghrHgS-wdwI7ot6wKMv3Tm5huROcELMCAbO2S8U48AojsA69KXrIyZUss_3H4BL0RT-nj77ozNAgiMVq8TWIAGDLTQK7nytmcdLKIZtxZTGmW79ycuCYmrB9kfH6pVFGUziqBQWO2p993FR6-3UxOc-2KEejkdO0FITcJwLw7auFC5yRyC3MoOCTgHvC2oep0hqe05piGjMVlKl3vIChaTy6MQDdKIuoxiGv-lmTtNTW0GzHTCTETZ6X7Xq6_OGwerrWZL8VHDr66kwas4OL7fHyo2z1_CPtQuRvvzCZ0JYHFNFFzWViJgToVLCiPNXN1kp4d-2z1WaTmC7iQpG3Ymb5CuOCrFFmBRllNSw6w3_iJWmkrIm_EOnIYPxc7YTEN4W34LymohgcOWgIY4BJ3-gP_UVogJCbTZgPXhDXzHWtBjNrit4M7YsRzmJ8w3nPSMYNbwauc0mSQw55H7KAeFhqs6zHd0muy77gBISkWmYVrwggH7ho6swl5JhePQHd1y4lX1sz9zy9cSUfXIstbM52Bkf-sFVWETw2igvhmBRzMaEEuBhT646fw3l5CQ4NE5oUQoCc70NDv4T5ZBG7ZlG6DEqTJSyRUeFB4WomKV2Dszk_QmPudNlnjNbWLpkPqchXlVorDbU5PYDpwKyc2Vck_-h5o64MmPg2YP8P7LRnORunegfwI-4J3yy_MuCRmNwX4ZMIjhekZUa-N7Qhcq6dde.FSmJZOTTi1Sbfe_bSPZHYg',
                'token_type' => 'bearer',
                'x_refresh_token_expires_in' => 8726400,
                'expires_in' => 3600,
                'expiresAccessToken' => 1709731251,
                'expiresRefreshToken' => 1718454051,
            ],
            'integration_settings' => [
                'settings' => [
                    'sync_start_date' => now()->subYear(),
                ],
            ],
        ];
    }
}
