<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('qbo_contacts', function (Blueprint $table) {
            $table->id();
            $table->string('contactId')->nullable();
            $table->string('contactType')->nullable();
            $table->string('DisplayName')->nullable();
            $table->integer('link_id')->nullable();
            $table->string('link_type')->nullable();
            $table->json('last_error')->nullable();
            $table->timestamps();
            $table->unique(['contactId', 'contactType']);
            $table->unique(['link_id', 'link_type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('qbo_contacts');
    }
};
