<?php

namespace Modules\Qbo\Data;

use Carbon\Carbon;
use Spatie\LaravelData\Data;

class QboVendorData extends Data
{
    public function __construct(
        public string $Id,
        public string $DisplayName,
        public array $json_object,
    ) {
        $this->json_object['LastUpdatedTimeUtc'] = $this->json_object['MetaData']['LastUpdatedTime'] ? Carbon::parse($this->json_object['MetaData']['LastUpdatedTime'])->setTimezone('UTC')->toDateTimeString() : null;
    }
}
