<?php

namespace Modules\Qbo\Data;

use App\Abstractions\Integrations\Data\OauthAuthenticationAuthorizationResponseInterface;
use Spatie\LaravelData\Data;

class QboAuthorizationResponseData extends Data implements OauthAuthenticationAuthorizationResponseInterface
{
    public function __construct(
        public string $state,
        public string $code,
        public string $realmId,
    ) {
    }

    public function getAuthCode(): string
    {
        return $this->code;
    }

    public function getAdditionalInfo(): array
    {
        return [
            'realmId' => $this->realmId,
        ];
    }
}
