<?php

namespace Modules\Qbo\Console;

use App\Models\SalesOrder;
use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Console\Command;
use Modules\Qbo\Manager\QboManager;

class SyncQboInvoicesCommand extends Command
{
    public function __construct(private readonly IntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'qbo:sync:invoices';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync sales orders.';

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        (new QboManager($this->integrationInstanceRepository->getQboAccountingInstance()))->syncTransactions([], SalesOrder::class, 30);
    }
}
