<?php

namespace Modules\Qbo\Console;

use App\Models\SalesCredit;
use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Console\Command;
use Modules\Qbo\Manager\QboManager;

class SyncQboCreditMemosCommand extends Command
{
    public function __construct(private readonly IntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'qbo:sync:credit-memos';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync purchase orders.';

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        (new QboManager($this->integrationInstanceRepository->getQboAccountingInstance()))->syncTransactions([], SalesCredit::class, 30);
    }
}
