<?php

namespace Modules\Qbo\Console;

use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Console\Command;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\Jobs\RefreshQboTaxCodesJob;

class RefreshQboTaxCodesCommand extends Command
{
    public function __construct(private readonly IntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'qbo:tax-codes:refresh {--lastUpdatedAfter=} {--days=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh QuickBooks Online Tax Rates';

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        $parameters = new QboQueryApo();

        RefreshQboTaxCodesJob::dispatch(
            $this->integrationInstanceRepository->getQboAccountingInstance(),
            $parameters,
        )->onQueue('accounting');
    }
}
