<?php

namespace Modules\Qbo\ApiParameterObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Models\Payment;
use App\Models\SalesCredit;
use App\Models\SalesOrder;
use Illuminate\Support\Collection;
use Modules\Qbo\Data\QboCreatePaymentLineData;
use Modules\Qbo\Data\QboCreatePaymentsData;
use Modules\Qbo\Entities\QboCustomer;
use Modules\Qbo\Repositories\QboAccountRepository;
use Modules\Qbo\Repositories\QboCustomerRepository;

class QboUpdateOrCreatePaymentsApo implements ApiDataTransformerInterface
{
    public QboAccountRepository $accounts;

    public QboCustomerRepository $customers;

    public function __construct(
        public Collection $payments
    ) {
        $this->customers = app(QboCustomerRepository::class);
    }

    private function getLinkedTxnType(Payment $payment)
    {
        $type = null;

        switch (get_class($payment->link)) {
            case SalesOrder::class:
                $type = 'Invoice';
                break;

            case SalesCredit::class:
                $type = 'CreditMemo';
                break;
        }

        return $type;
    }

    public function transform(): array
    {
        $payments = [];

        $this->payments->each(function (Payment $payment) use (&$payments) {
            $lineItems = [];
            $amount = $payment->amount;

            $lineItems[] = QboCreatePaymentLineData::from([
                'Amount' => $amount,
                'LinkedTxn' => [
                    [
                        'TxnId' => $payment->link->accountingTransaction->accountingIntegration->QboId,
                        'TxnType' => $this->getLinkedTxnType($payment),
                    ],
                ],

            ])->toArray();

            /**
             * For Credit Memos we can only update and can't create new payments
             */
            if ($payment->link_type === SalesCredit::class) {
                $lineItems[] = QboCreatePaymentLineData::from([
                    'Amount' => $amount,
                    'LinkedTxn' => [
                        [
                            'TxnId' => $payment->link->salesOrder->accountingTransaction->accountingIntegration->QboId,
                            'TxnType' => 'Invoice',
                        ],
                    ],

                ])->toArray();
            }

            $data = QboCreatePaymentsData::from([
                'TotalAmt' => $amount,
                'TxnDate' => $payment->payment_date->format('Y-m-d'),
                'CustomerRef' => [
                    'value' => ! is_null($payment->link->customer?->name) ? $this->customers->getQboCustomerByDisplayName($payment->link->customer->name)->QboId : $this->customers->getQboCustomerByDisplayName(QboCustomer::MISSING_CUSTOMER_NAME)->QboId,
                ],
                'Line' => $lineItems,
                'PaymentRefNum' => $payment->external_reference ?? 'Payment '.$payment->id,
            ]);

            if ($payment->link_type === SalesCredit::class) {
                $existingQboPayment = $payment->link->salesOrder->payments->first()->accountingIntegration; //TODO: Check with Kalvin

                $data->PaymentRefNum = $existingQboPayment->PaymentRefNum;
                $data->SyncToken = $existingQboPayment->json_object['SyncToken'];
                $data->Id = $existingQboPayment->QboId;
            } elseif ($QboId = $payment->accountingIntegration?->QboId) {
                $data->Id = $QboId;
                $data->SyncToken = $payment->accountingIntegration->json_object['SyncToken'];
            }

            $payments[] = $data->toArray();
        });

        $params = [
            'records' => $payments,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
