<?php

namespace Modules\Qbo\ApiParameterObjects;

class QboQueryItemApo extends QboQueryApo
{
    public function __construct(
        public ?string $Name = null
    ) {
        parent::__construct();
    }

    public function transform(): array
    {
        $params = [
            'startPosition' => $this->startPosition,
            'maxResults' => $this->maxResults,
            'whereClause' => [
                'Name' => $this->Name,
            ],
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
