<?php

namespace Modules\Qbo\ApiParameterObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;

class QboQueryApo implements ApiDataTransformerInterface
{
    public function __construct(
        public int $startPosition = 1,
        public int $maxResults = 1000,
    ) {
    }

    public function transform(): array
    {
        $params = [
            'startPosition' => $this->startPosition,
            'maxResults' => $this->maxResults,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
