<?php

namespace Modules\Ebay\Tests\Feature\Controllers;

use App\Models\Product;
use App\Models\User;
use Laravel\Sanctum\Sanctum;
use Modules\Ebay\Data\EbayProductSettingData;
use Modules\Ebay\Entities\EbayProductSetting;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class EbayProductSettingControllerTest extends TestCase
{
    use FastRefreshDatabase;

    public function setUp(): void
    {
        parent::setUp();

        Sanctum::actingAs(User::first());
    }

    public function test_it_can_create_and_update_ebay_product_settings()
    {
        $product = Product::factory()->create();

        $data = EbayProductSettingData::from([
            'integration_instance_id' => 1,
            'product_id' => $product->id,
            'auction_until_sold_enabled' => true,
            'auction_until_sold_price_reduction_percentage' => 10.0,
            'auction_until_sold_minimum_price' => 100.0,
        ]);

        $this->postJson(route('ebay-product-settings.store'), $data->toArray())->assertOk();

        $this->assertDatabaseHas((new EbayProductSetting)->getTable(), $data->toArray());

        $data->auction_until_sold_price_reduction_percentage = 20.0;

        $this->postJson(route('ebay-product-settings.store'), $data->toArray())->assertOk();

        $this->assertDatabaseHas((new EbayProductSetting)->getTable(), $data->toArray());

        $this->getJson(route('ebay-product-settings.index') . '?product_id=' . $product->id)->assertJsonCount(1);
    }
}
