<?php

namespace Modules\Ebay\Tests;

use Illuminate\Http\Client\Request;
use Illuminate\Support\Facades\Http;

trait EbayMockRequests
{
    public function mockRefreshOrders(): void
    {
        Http::fake([
            '*/sell/fulfillment/v1/order?*' => Http::response(EbayTestingData::getOrders()),
        ]);
    }

    public function mockRefreshLegacyProducts(): void
    {
        Http::fake(function (Request $request) {
            if ($request->url() !== config('ebay.trading.domain')) {
                return false;
            }
            if ($request->header('X-EBAY-API-CALL-NAME')[0] == 'GetMyeBaySelling') {
                return Http::response(EbayTestingData::getLegacyProducts());
            }
            return false;
        });
    }

    public function mockLegacyReviseInventoryStatus(): void
    {
        Http::fake(function (Request $request) {
            if ($request->url() !== config('ebay.trading.domain')) {
                return false;
            }
            if ($request->header('X-EBAY-API-CALL-NAME')[0] == 'ReviseInventoryStatus') {
                return Http::response(EbayTestingData::getLegacyReviseInventoryStatusResponse());
            }
            return false;
        });
    }

    public function mockFulfillOrder(): void
    {
        Http::fake([
            '*/sell/fulfillment/v1/order/*/shipping_fulfillment' => Http::response('https://api.ebay.com/sell/fulfillment/v1/
   order/6498414015!260000000562911/shipping_fulfillment/9405509699937003457459', 201),
        ]);
    }

    public function mockAddItem(): void
    {
        Http::fake(function (Request $request) {
            if ($request->url() !== config('ebay.trading.domain')) {
                return false;
            }
            if ($request->header('X-EBAY-API-CALL-NAME')[0] == 'AddItem') {
                return Http::response(EbayTestingData::getAddItemResponse());
            }
            return false;
        });
    }

    public function mockRelistItem(): void
    {
        Http::fake(function (Request $request) {
            if ($request->url() !== config('ebay.trading.domain')) {
                return false;
            }
            if ($request->header('X-EBAY-API-CALL-NAME')[0] == 'RelistItem') {
                return Http::response(EbayTestingData::getRelistItemResponse());
            }
            return false;
        });
    }

    public function mockUploadSiteHostedPictures(): void
    {
        Http::fake(function (Request $request) {
            if ($request->url() !== config('ebay.trading.domain')) {
                return false;
            }
            if ($request->header('X-EBAY-API-CALL-NAME')[0] == 'UploadSiteHostedPictures') {
                return Http::response(EbayTestingData::getUploadSiteHostedPictureResponse());
            }
            return false;
        });
    }

    public function mockGetItem(): void
    {
        Http::fake(function (Request $request) {
            if ($request->url() !== config('ebay.trading.domain')) {
                return false;
            }
            if ($request->header('X-EBAY-API-CALL-NAME')[0] == 'GetItem') {
                return Http::response(EbayTestingData::getGetItemResponse());
            }
            return false;
        });
    }

    public function mockGetSuggestedCategories(): void
    {
        Http::fake(function (Request $request) {
            if ($request->url() !== config('ebay.trading.domain')) {
                return false;
            }
            if ($request->header('X-EBAY-API-CALL-NAME')[0] == 'GetSuggestedCategories') {
                return Http::response(EbayTestingData::getSuggestedCategoriesResponse());
            }
            return false;
        });
    }

    public function mockRefreshTokenFromAuthCode(): void
    {
        Http::fake([
            config('ebay.user_authorization_url') => Http::response(EbayTestingData::getRefreshTokenFromAuthCode()),
        ]);
    }

    public function mockGetAccessToken(): void
    {
        Http::fake([
            config('ebay.tokens.token_url') => Http::response(EbayTestingData::getAccessToken()),
        ]);
    }
}
