<?php

declare(strict_types=1);

namespace Modules\Ebay\Services;

use App\Models\ShippingMethod;

class ShippingMethodMapper
{
    protected static array $mapping = [
        'ShippingMethodExpress' => 'UPS 2nd Day Air',
    ];

    /**
     * Looks up an internal shipping method and returns the Ebay shipping method.
     */
    public static function translateSkuShippingMethodToEbayShippingMethod(ShippingMethod|string $shippingMethod): string
    {
        $lookup = $shippingMethod instanceof ShippingMethod ? $shippingMethod->name : $shippingMethod;

        return (string) (self::$mapping[$lookup] ?? '');
    }

    /**
     * Reverses the translation from Ebay to the internal shipping method.
     */
    public static function translateEbayShippingMethodToSkuShippingMethod(string $shippingMethod): string
    {
        $lookup = array_search($shippingMethod, self::$mapping, true);

        return (string) ($lookup ?: '');
    }
}
