<?php

declare(strict_types=1);

namespace Modules\Ebay\Services\Api\Inventory;

/**
 * Class InventoryMock
 */
class InventoryMock
{
    public function getInventoryItems()
    {
        $response = <<<EOT
{
  "total": 2,
  "size": 2,
  "href": "/sell/inventory/v1/inventory_item?offset=0&limit=2",
  "limit": 2,
  "inventoryItems": [
    {
      "sku": "40501",
      "locale": "en_US",
      "product": {
        "title": "Test listing - do not bid or buy - Levi's 501 Jean - Cat Shadow 34x32",
        "aspects": {
          "CPU": [
            "Dual-Core Processor"
          ],
          "Feature": [
            "Water resistance",
            "GPS"
          ]
        },
        "description": "Test listing - do not bid or buy \n Built-in GPS. Water resistance to 50 meters.1 A new lightning-fast dual-core processor. And a display that’s two times brighter than before. Full of features that help you stay active, motivated, and connected, Apple Watch Series 2 is designed for all the ways you move ",
        "upc": [
          "888462079525"
        ],
        "imageUrls": [
          "http://store.storeimages.cdn-apple.com/4973/as-images.apple.com/is/image/AppleInc/aos/published/images/S/1/S1/42/S1-42-alu-silver-sport-white-grid?wid=332&hei=392&fmt=jpeg&qlt=95&op_sharpen=0&resMode=bicub&op_usm=0.5,0.5,0,0&iccEmbed=0&layer=comp&.v=1472247758975",
          "http://store.storeimages.cdn-apple.com/4973/as-images.apple.com/is/image/AppleInc/aos/published/images/4/2/42/stainless/42-stainless-sport-white-grid?wid=332&hei=392&fmt=jpeg&qlt=95&op_sharpen=0&resMode=bicub&op_usm=0.5,0.5,0,0&iccEmbed=0&layer=comp&.v=1472247760390",
          "http://store.storeimages.cdn-apple.com/4973/as-images.apple.com/is/image/AppleInc/aos/published/images/4/2/42/ceramic/42-ceramic-sport-cloud-grid?wid=332&hei=392&fmt=jpeg&qlt=95&op_sharpen=0&resMode=bicub&op_usm=0.5,0.5,0,0&iccEmbed=0&layer=comp&.v=1472247758007"
        ]
      },
      "availability": {
        "shipToLocationAvailability": {
          "quantity": 10
        }
      }
    },
    {
      "sku": "40500",
      "locale": "en_US",
      "product": {
        "title": "Test listing - do not bid or buy - awesome Apple watch test 1223",
        "aspects": {
          "CPU": [
            "Dual-Core Processor"
          ],
          "Feature": [
            "Water resistance",
            "GPS"
          ]
        },
        "description": "Test listing - do not bid or buy \n Built-in GPS. Water resistance to 50 meters.1 A new lightning-fast dual-core processor. And a display that’s two times brighter than before. Full of features that help you stay active, motivated, and connected, Apple Watch Series 2 is designed for all the ways you move ",
        "upc": [
          "888462079525"
        ],
        "imageUrls": [
          "http://store.storeimages.cdn-apple.com/4973/as-images.apple.com/is/image/AppleInc/aos/published/images/S/1/S1/42/S1-42-alu-silver-sport-white-grid?wid=332&hei=392&fmt=jpeg&qlt=95&op_sharpen=0&resMode=bicub&op_usm=0.5,0.5,0,0&iccEmbed=0&layer=comp&.v=1472247758975",
          "http://store.storeimages.cdn-apple.com/4973/as-images.apple.com/is/image/AppleInc/aos/published/images/4/2/42/stainless/42-stainless-sport-white-grid?wid=332&hei=392&fmt=jpeg&qlt=95&op_sharpen=0&resMode=bicub&op_usm=0.5,0.5,0,0&iccEmbed=0&layer=comp&.v=1472247760390",
          "http://store.storeimages.cdn-apple.com/4973/as-images.apple.com/is/image/AppleInc/aos/published/images/4/2/42/ceramic/42-ceramic-sport-cloud-grid?wid=332&hei=392&fmt=jpeg&qlt=95&op_sharpen=0&resMode=bicub&op_usm=0.5,0.5,0,0&iccEmbed=0&layer=comp&.v=1472247758007"
        ]
      },
      "availability": {
        "shipToLocationAvailability": {
          "quantity": 10
        }
      }
    }
  ]
}
EOT;

        return preg_replace('/[\x00-\x1F\x7F]/', '', $response);
    }
}
