<?php

use Illuminate\Support\Facades\Route;
use Modules\Ebay\Http\Controllers\EbayAuthenticationController;
use Modules\Ebay\Http\Controllers\EbayFulfillmentController;
use Modules\Ebay\Http\Controllers\EbayGlobalReportController;
use Modules\Ebay\Http\Controllers\EbayIntegrationInstanceController;
use Modules\Ebay\Http\Controllers\EbayInventoryController;
use Modules\Ebay\Http\Controllers\EbayLegacyProductController;
use Modules\Ebay\Http\Controllers\EbayOrderController;
use Modules\Ebay\Http\Controllers\EbayProductSettingController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->group(function () {
    Route::salesChannel(
        'ebay',
        EbayLegacyProductController::class,
        EbayOrderController::class,
        EbayFulfillmentController::class,
        EbayAuthenticationController::class,
        EbayIntegrationInstanceController::class
    );
    Route::prefix('ebay/{integrationInstance}')->name('ebay.')->group(function () {
        Route::controller(EbayLegacyProductController::class)->prefix('legacy-products')->name('legacy-products.')->group(function () {
            Route::post('create-sku-products', 'createSkuProducts')->name('create-sku-products');
            Route::post('refresh', 'refresh')->name('refresh');
            Route::put('map', 'mapProducts')->name('map');
            Route::get('export', 'exportForIntegration')->name('export');
            Route::post('import-mappings', 'importMappings')->name('import-mappings');
            Route::post('sync-inventory', 'syncInventory')->name('sync-inventory');
            Route::post('hydrate-product-template', 'hydrateProductTemplate')->name('hydrate-product-template');
            Route::post('get-suggested-categories', 'getSuggestedCategories')->name('get-suggested-categories');
            Route::post('build-payload', 'buildPayload')->name('build-payload');
            Route::post('publish', 'publish')->name('publish');
            Route::get('/', 'indexForIntegration')->name('index');
        });
        Route::apiResource('/legacy-products', EbayLegacyProductController::class)->parameters(['legacy-products' => 'product'])->except('index');
    });
    Route::resource('ebay-product-settings', EbayProductSettingController::class)->only(['store', 'index']);
    Route::prefix('ebay-global-reports')->name('ebay-global-reports.')->controller(EbayGlobalReportController::class)->group(function () {
        Route::get('uncovered-blemished-products', 'getUncoveredBlemishedProducts')->name('uncovered-blemished-products');
        Route::get('listed-blemished-products-out-of-stock', 'getListedBlemishedProductsOutOfStock')->name('listed-blemished-products-out-of-stock');
    });
});
