<?php

namespace Modules\Ebay\Repositories;

use App\Abstractions\AbstractRepository;
use App\Models\Product;
use Illuminate\Support\Collection;
use Modules\Ebay\Entities\EbayProductSetting;

class EbayProductSettingRepository extends AbstractRepository
{
    public function getForProduct(Product $product): Collection
    {
        return EbayProductSetting::with('integrationInstance')->where('product_id', $product->id)->get();
    }
}