<?php

declare(strict_types=1);

namespace Modules\Ebay\Repositories;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelOrderRepository;
use Illuminate\Support\Collection;
use Modules\Ebay\Entities\EbayOrder;
use Modules\Ebay\Entities\EbayOrderItem;
use Modules\Ebay\Enums\EbayOrderFulfillmentStatusEnum;
use Modules\Ebay\Enums\EbayOrderPaymentStatusEnum;

class EbayOrderRepository extends AbstractSalesChannelOrderRepository
{
    protected static function getModelClassName(): string
    {
        return EbayOrder::class;
    }

    protected static function getLinesModelClassName(): string
    {
        return EbayOrderItem::class;
    }

    public function getCanceledOrders(IntegrationInstanceInterface $integrationInstance, ?Collection $collection = null): Collection
    {
        return parent::getCanceledOrdersQuery($integrationInstance, $collection)
            ->where('orderFulfillmentStatus', EbayOrderFulfillmentStatusEnum::NOT_STARTED)
            ->where('orderPaymentStatus', EbayOrderPaymentStatusEnum::FULLY_REFUNDED)
            ->get();
    }


}
