<?php

declare(strict_types=1);

namespace Modules\Ebay\Managers;

use App\Abstractions\Integrations\IntegrationClientInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelProductManager;
use App\Abstractions\Integrations\SalesChannels\SalesChannelProductRepositoryInterface;
use Exception;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Entities\EbayProduct;
use Modules\Ebay\Repositories\EbayProductRepository;
use Modules\Ebay\Services\EbayClient;

class EbayProductManager extends AbstractSalesChannelProductManager
{
    private EbayProductRepository $ebayProductsRepository;

    public function __construct(EbayIntegrationInstance $ebayIntegrationInstance)
    {
        $this->ebayProductsRepository = app(EbayProductRepository::class);
        $this->setModel(new EbayProduct());

        parent::__construct($ebayIntegrationInstance, new EbayClient($ebayIntegrationInstance), $this->ebayProductsRepository);

        config()->set('ebay_mappings', $this->mappings);
    }


    protected function getProductRepository(): SalesChannelProductRepositoryInterface
    {
        return $this->ebayProductsRepository;
    }

    // TODO: Implement getStartDateForNew for products before it gets used

    protected function postCreateSkuProducts()
    {
        // TODO: Implement postCreateSkuProducts() method.
    }

    protected function syncInventory(?array $ids = []): void
    {
        // TODO: Implement syncInventory() method.
    }


}
