<?php

namespace Modules\Ebay\Managers;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelOrderManager;
use App\Models\SalesOrderFulfillment;
use Exception;
use Modules\Ebay\ApiDataTransferObjects\EbayFulfillOrderAdt;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Entities\EbayOrder;
use Modules\Ebay\Repositories\EbayOrderRepository;
use Modules\Ebay\Services\EbayClient;

class EbayOrderManager extends AbstractSalesChannelOrderManager
{
    private EbayOrderRepository $ebayOrderRepository;

    /**
     * @throws Exception
     */
    public function __construct(protected EbayIntegrationInstance $ebayIntegrationInstance)
    {
        $this->ebayOrderRepository = app(EbayOrderRepository::class);

        $this->setModel(new EbayOrder());

        parent::__construct($ebayIntegrationInstance, new EbayClient($this->ebayIntegrationInstance), $this->ebayOrderRepository);
    }

    protected function getOrderRepository()
    {
        return $this->ebayOrderRepository;
    }

    protected function postProcess(?string $orderId = null): void
    {
        // No post-processing required
    }

    public function postProcessItems(): void
    {
        // No post-processing required
    }

    public function fulfillOrderForSalesOrderFulfillment(
        SalesOrderFulfillment $salesOrderFulfillment,
        ?ApiDataTransformerInterface $parameters = null
    ): void
    {
        $parameters = new EbayFulfillOrderAdt($salesOrderFulfillment);
        parent::fulfillOrderForSalesOrderFulfillment($salesOrderFulfillment, $parameters);
    }
}
