<?php

namespace Modules\Ebay\Managers;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelInventoryManager;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Services\EbayClient;

class EbayInventoryManager extends AbstractSalesChannelInventoryManager
{
    public function __construct(EbayIntegrationInstance $integrationInstance)
    {
        parent::__construct($integrationInstance, new EbayClient($integrationInstance));
    }

    // TODO: Add optional parameter for a collection of sales channel products in case the user wants to sync specific products
    public function syncInventory(array $ids = []): void
    {
        // Check if sku is master of stock, otherwise early return
        // Get product listings where:
        // - sales channel qty is null
        // - or sales channel qty != quantity
        // - sales_channel_qty_last_updated (used only if there is a way to get initial inventory from the sales channel)... in which case we should check that it is not null (meaning we have the initial sales channel values)... otherwise it needs to be fetched from return values of pushing inventory
        // - build adt
        // - make api call
        // - update sales channel qty and sales_channel_qty_last_updated
    }
}