<?php

namespace Modules\Ebay\Jobs;

use App\Abstractions\Integrations\ClientResponseDataInterface;
use Exception;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Ebay\ApiDataTransferObjects\EbayGetProductsAdt;
use Modules\Ebay\Data\EbayResponseData;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Jobs\Abstractions\EbayJob;
use Modules\Ebay\Managers\EbayProductManager;

class RefreshEbayProductsJob extends EbayJob implements ShouldBeUnique
{
    public string $uniqueId;

    public int $uniqueFor = 60 * 10;

    public function __construct(
        protected EbayIntegrationInstance $ebayIntegrationInstance,
        protected EbayGetProductsAdt $parameters
    ) {
        $this->uniqueId = get_class($this).':'.$this->ebayIntegrationInstance->id;
    }

    /**
     * @throws Exception
     */
    public function apiCall(): EbayResponseData|ClientResponseDataInterface
    {
        $ebayProductManager = new EbayProductManager($this->ebayIntegrationInstance);

        return $ebayProductManager->refreshProducts(
            $this->parameters
        );
    }
}
