<?php

namespace Modules\Ebay\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Ebay\Entities\EbayLegacyProduct;

/**
 * @mixin EbayLegacyProduct
 */
class EbayProductResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this['id'],
            'SKU' => $this->inclusive('SKU', $this->SKU),
            'ItemID' => $this->inclusive('ItemID', $this->ItemID),
            'Title' => $this->inclusive('name', $this->Title),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'json_object' => $this->inclusive('json_object', $this->json_object),
        ];
    }
}
