<?php

namespace Modules\Ebay\Http\Requests\EbayLegacyProduct;

use Illuminate\Foundation\Http\FormRequest;

class MapEbayProductRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'mapping' => 'required|array|min:1',
            // TODO: Need to use required_if to make sure that either amazon_product_id or amazon_seller_sku is provided
            'mapping.*.listing_sku' => 'exists:ebay_legacy_products,sku',
            // 'mapping.*.seller_sku'  => 'exists:amazon_products,seller_sku',
            // TODO: Need to use required_if to make sure that either product_id or product_sku is provided
            // 'mapping.*.product_id'  => 'exists:products,id|nullable',
            'mapping.*.mapped_sku' => 'exists:products,sku|nullable',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
