<?php

namespace Modules\Ebay\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;
use Modules\Ebay\Data\EbayProductSettingData;
use Modules\Ebay\Entities\EbayProductSetting;
use Modules\Ebay\Repositories\EbayProductSettingRepository;

class EbayProductSettingController extends Controller
{
    private EbayProductSettingRepository $settings;

    public function __construct()
    {
        parent::__construct();
        $this->settings = app(EbayProductSettingRepository::class);
    }

    public function index(Request $request)
    {
        $request->validate([
            'product_id' => 'required|integer|exists:products,id',
        ]);
        $product = Product::findOrFail($request->product_id);
        return $this->settings->getForProduct($product);
    }

    public function store(EbayProductSettingData $data)
    {
        $this->settings->save($data, EbayProductSetting::class);
    }
}
