<?php

namespace Modules\Ebay\Http\Controllers;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelProductController;
use App\Response;
use Illuminate\Http\Request;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Entities\EbayProduct;
use Modules\Ebay\Http\Requests\EbayProduct\CreateSkuProductRequest;
use Modules\Ebay\Http\Resources\EbayProductResource;
use Modules\Ebay\Jobs\RefreshEbayProductsJob;
use Throwable;

class EbayProductController extends AbstractSalesChannelProductController
{
    protected function getModel(): string
    {
        return EbayProduct::class;
    }

    protected function getResource(): string
    {
        return EbayProductResource::class;
    }

    // Typehint $integrationInstance with the integration implementation
    public function indexForIntegration(Request $request, EbayIntegrationInstance $integrationInstance)
    {
        return parent::abstractIndexForIntegration($request, $integrationInstance);
    }

    // Typehint $product with the integration implementation
    public function show(EbayIntegrationInstance $integrationInstance, EbayProduct $product): ?Response
    {
        return $this->abstractShow($product);
    }

    /**
     * @throws Throwable
     */
    public function createSkuProducts(CreateSkuProductRequest $request, EbayIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractCreateSkuProducts($request, $integrationInstance);
    }

    public function refresh(EbayIntegrationInstance $integrationInstance): Response
    {
        dispatch(new RefreshEbayProductsJob($integrationInstance, app($this->getModel())->refreshAdt()));

        return $this->response->success();
    }

    /**
     * @throws Throwable
     */
    public function mapProducts(Request $request, EbayIntegrationInstance $integrationInstance)
    {
        return $this->abstractMapProducts($request, $integrationInstance);
    }
}
