<?php

namespace Modules\Ebay\Http\Controllers;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelOrderController;
use App\Data\CreateSkuOrderFromSalesChannelData;
use App\Exceptions\ExportingEmptyDataException;
use App\Response;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Entities\EbayOrder;
use Modules\Ebay\Http\Resources\EbayOrderResource;
use Modules\Ebay\Jobs\RefreshEbayOrdersJob;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Throwable;

class EbayOrderController extends AbstractSalesChannelOrderController
{
    protected function getModel(): string
    {
        return EbayOrder::class;
    }

    protected function getResource(): string
    {
        return EbayOrderResource::class;
    }

    // Typehint $integrationInstance with the integration implementation
    public function indexForIntegration(Request $request, EbayIntegrationInstance $integrationInstance)
    {
        return $this->abstractIndexForIntegration($request, $integrationInstance);
    }

    // Typehint $order with the integration implementation
    function show(EbayIntegrationInstance $integrationInstance, EbayOrder $order)
    {
        return $this->abstractShow($order);
    }

    public function refresh(EbayIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractRefresh(new RefreshEbayOrdersJob($integrationInstance, app($this->getModel())->refreshAdt()));
    }

    /**
     * Typehint $integrationInstance with the integration implementation
     *
     * @throws Throwable
     */
    public function createSkuOrders(CreateSkuOrderFromSalesChannelData $data, EbayIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractCreateSkuOrders($data, $integrationInstance);
    }


    /**
     * @throws ExportingEmptyDataException
     */
    protected function exportForIntegration(Request $request, EbayIntegrationInstance $integrationInstance): BinaryFileResponse|Response|RedirectResponse
    {
        return $this->abstractExportForIntegration($request, $integrationInstance);
    }
}
