<?php

namespace Modules\Ebay\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Response;
use Modules\Ebay\Managers\EbayGlobalReportManager;

class EbayGlobalReportController extends Controller
{
    protected EbayGlobalReportManager $manager;

    public function __construct()
    {
        parent::__construct();
        $this->manager = app(EbayGlobalReportManager::class);
    }

    public function getUncoveredBlemishedProducts(): Response
    {
        $data = $this->manager->getUncoveredBlemishedProducts();

        return $this->response->success()
            ->addData($data);
    }

    public function getListedBlemishedProductsOutOfStock(): Response
    {
        $data = $this->manager->getListedBlemishedProductsOutOfStock();

        return $this->response->success()
            ->addData($data);
    }
}
