<?php

declare(strict_types=1);

namespace Modules\Ebay\Entities;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelProduct;
use App\Abstractions\Integrations\SalesChannels\SalesChannelInventoryManagerInterface;
use App\Abstractions\Integrations\SalesChannels\SalesChannelProductManagerInterface;
use App\Abstractions\Integrations\SalesChannels\SalesChannelProductRepositoryInterface;
use App\Collections\ProductImageCollection;
use App\DTO\ProductDto;
use App\DTO\ProductPricingDto;
use App\Models\Concerns\BulkImport;
use App\Models\Concerns\HasFilters;
use App\Models\Concerns\HasSort;
use App\Models\ProductPricingTier;
use Exception;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Ebay\ApiDataTransferObjects\EbayGetOrdersAdt;
use Modules\Ebay\Managers\EbayInventoryManager;
use Modules\Ebay\Managers\EbayProductManager;
use Modules\Ebay\Repositories\EbayProductRepository;
use Spatie\LaravelData\DataCollection;

/**
 * Class EbayProduct
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property string $sku
 * @property array $json_object
 */
class EbayProduct extends AbstractSalesChannelProduct
{
    use BulkImport,
        HasFactory,
        HasFilters,
        HasSort;

    const BULK_THRESHOLD = 50;

    protected $guarded = [];

    protected $table = 'ebay_products';

    protected $casts = [
        'json_object' => 'array',
        'last_synced_at' => 'datetime',
        'product_aspects' => 'array',
    ];

    public string $dataTableClass = self::class;

    public string $dataTableKey = 'ebay.product';

    public static function getIntegrationName(): string
    {
        return 'ebay';
    }

    public static function getLastModified(): ?string
    {
        return 'lastModifiedDate';
    }

    public static function getUniqueField(): string
    {
        // TODO: Implement getUniqueField() method.
    }

    public function getListingUrl(): ?string
    {
        return "https://www.ebay.com/itm/{$this->ItemID}";
    }

    public function isActive(): bool
    {
        // TODO: Implement
        return true;
    }

    /*
    |--------------------------------------------------------------------------
    | Implementers
    |--------------------------------------------------------------------------
    */
    public function availableColumns(): array
    {
        // TODO: Implement availableColumns() method.
    }

    public function filterableColumns(): array
    {
        // TODO: Implement filterableColumns() method.
    }

    public function generalFilterableColumns(): array
    {
        // TODO: Implement generalFilterableColumns() method.
    }

    public function sortableColumns(): array
    {
        // TODO: Implement sortableColumns() method.
    }

    public function isUsed(): bool|array
    {
        // TODO: Implement isUsed() method.
    }


    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */
    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(AmazonIntegrationInstance::class);
    }

    public static function getSkuField(): string
    {
        // TODO: Implement getSkuField() method.
    }

    public static function getPriceField(): string
    {
        // TODO: Implement getPriceField() method.
    }

    public function getProductDto(): ProductDto
    {
        // TODO: Implement getProductDto() method.
    }

    public function getProductPricingDto(): ProductPricingDto
    {
        // TODO: Implement getProductPricingDto() method.
    }

    public function getImages(): DataCollection
    {
        // TODO: Implement getProductImageCollection() method.
    }

    public function applyDataMapping(mixed $data, string $mappedColumn): mixed
    {
        // TODO: Implement applyDataMapping() method.
    }

    /**
     * @throws Exception
     */
    public function manager(EbayIntegrationInstance|IntegrationInstanceInterface $integrationInstance): SalesChannelProductManagerInterface
    {
        return new EbayProductManager($integrationInstance);
    }

    public function refreshAdt(): ApiDataTransformerInterface
    {
        return new EbayGetOrdersAdt();
    }

    public static function repository(): SalesChannelProductRepositoryInterface
    {
        return app(EbayProductRepository::class);
    }


}
