<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('ebay_legacy_products', function (Blueprint $table) {
            $table->string('ListingStatus')->nullable()->storedAs("JSON_UNQUOTE(JSON_EXTRACT(`json_object`, '$.SellingStatus.ListingStatus'))")->after('CurrentPriceCurrency');
            $table->string('BidCount')->nullable()->storedAs("JSON_UNQUOTE(JSON_EXTRACT(`json_object`, '$.SellingStatus.BidCount'))")->after('ListingStatus');
            $table->string('EndingReason')->nullable()->storedAs("JSON_UNQUOTE(JSON_EXTRACT(`json_object`, '$.ListingDetails.EndingReason'))")->after('BidCount');
        });
    }

    public function down(): void
    {
        Schema::table('ebay_legacy_products', function (Blueprint $table) {
            $table->dropColumn('ListingStatus');
            $table->dropColumn('BidCount');
            $table->dropColumn('EndingReason');
        });
    }
};
