<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('ebay_product_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id');
            $table->foreignId('product_id');
            $table->boolean('auction_until_sold_enabled');
            $table->float('auction_until_sold_price_reduction_percentage')->nullable();
            $table->float('auction_until_sold_minimum_price')->nullable();
            $table->timestamps();
            $table->unique(['integration_instance_id', 'product_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ebay_product_settings');
    }
};
