<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('ebay_order_items', function (Blueprint $table) {
            // Drop the existing foreign key
            $table->dropForeign('ebay_order_items_ebay_order_id_foreign');

            // Add it back with onDelete('cascade')
            $table->foreign('ebay_order_id')
                ->references('id')
                ->on('ebay_orders')
                ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::table('ebay_order_items', function (Blueprint $table) {
            // Drop the foreign key with cascade delete
            $table->dropForeign('ebay_order_items_ebay_order_id_foreign');

            // Add it back with the original constraint
            $table->foreign('ebay_order_id')
                ->references('id')
                ->on('ebay_orders');
        });
    }
};
